#pragma once
#include "config.h"
#include "ServiceDataLink.h"
//////////////////////////////////////////////////////////////////////////////

//Keys
#define kDataSection		"Data"
	//PPP
#define kDataKeyPppHost		"pppHost"
#define kDataKeyPppPort		"pppPort"
#define kDataKeyPppProto	"pppProto"
	//IHOSS
#define kDataKeyIhossHost	"ihossHost"
#define kDataKeyIhossPort	"ihossPort"
#define kDataKeyIhossProto	"ihossProto"

	//Echo Service
#define kDataKeyEchoPort	"Echo"
	//Telnet Service
#define kDataKeyTelnetPort	"Telnet"
	//Daytime
#define kDataKeyDaytimePort "Daytime"


//default values
	//PPP
#define kDefPppHost			"rapanui2.palmsource.com"
#define kDefPppPort			"9010"
#define kDefPppProto		kProtoTCP
	//IHOSS
#define kDefIhossHost		""
#define kDefIhossPort		"23"
#define kDefIhossProto		"TCP"

	//Echo Service
#define kDataDefEchoPort	"7"
#define kDataStrEchoPort	"Echo"
	//Telnet Service
#define kDataDefTelnetPort	"23"
#define kDataStrTelnetPort	"Telenet"
	//Daytime
#define kDataDefDaytimePort "13"
#define kDataStrDaytimePort "Daytime"

//Possible values
#define kProtoTCP			"TCP"
#define kProtoUDP			"UDP"

#define	kLineOpened			0
#define	kLineClosed			1
#define kLineConnected		2
//////////////////////////////////////////////////////////////////////////
struct StructDataCounter 
{
	int cid;
	int ul_bytes;
	int dl_bytes;
	int ul_packets;
	int dl_packets;
};
//////////////////////////////////////////////////////////////////////////
enum EDataCounterValue
{
	eUlBytes = 0, 
	eDlBytes,
	eUlPackets,
	eDlPackets,	
};
//////////////////////////////////////////////////////////////////////////
#ifdef DLLMANAGER_EXPORTS
	#define DLLMANAGER_API __declspec(dllexport)
#else
	#define DLLMANAGER_API __declspec(dllimport)
#endif
//////////////////////////////////////////////////////////////////////////

class DLLMANAGER_API CConfigDATA :	public CConfig
{
private:
	CList<StructDataCounter, StructDataCounter&> mDataCounterList;
	CMapWordToOb mMapDataLink;
	CString		mCSDNumberInProgress; // if not empty, this csd call is connected
public:
	CConfigDATA() {};
	CConfigDATA(CDllManager* iDllManager);
	~CConfigDATA(void);

	virtual Bool Load();
	virtual Bool Save();
	virtual void SendGPRSNotif(int iLineState, int iChannel, int iContextID);
	virtual void SendCSDNotif(int iLineState, CDataLink* iLink, int iChannel);
	virtual CString GetCSDNumberInProgress() {return mCSDNumberInProgress;};

	CString GetPPPHost();
	CString GetPPPPort();
	CString GetPPPProto();

	void SetPPPHost(CString iHost);
	void SetPPPPort(CString iPort);
	void SetPPPProto(CString iProto);

	CString GetIHOSSHost();
	CString GetIHOSSPort();
	CString GetIHOSSProto();

	Bool GetPort(CString* ioPort);

	// Data Link Access
	Bool		IsOnLine(int iChannel);
	Bool		IsOnLine();
	void		CloseLine(int iChannel);
	void		CloseAllLine();
	void		OpenLine(int iChannel, CDataLink* iDataLink);
	CDataLink*	GetLine(int iChannel);	

	// Data Counter Access
	int GetCounterValue(int iCid, EDataCounterValue iValue);
	int AddOrUpdateCounter(int iCid, int iUlBytes=0, int iDlBytes=0, int iUlPackets=0, int iDlPackets=0);
	int ResetCounter(int iCid);	

protected:
	CString mPppHost;
	CString mPppPort;
	CString mPppProto;

	CString mIhossHost;
	CString mIhossPort;
	CString mIhossProto;

	CString mEchoPort;
	CString mTelnetPort;
	CString mDaytimePort;

	Bool mOnLine;

};
//////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////
